function plot_cumu_matrix(m,str, precision, linestyle)

if nargin<3 precision=1000; end
if nargin<2 str=''; end

% input values: [0, +oo]
% x axis : 0 - 1
% y axis : 0 - 1

m = ceil(m * 1000);
count = zeros(1, 1000);
total = zeros(1, 1000);
for i = 1:length(m)
    if (m(i) < 1000)
        count(m(i)+1) = count(m(i)+1) + 1;
    end
end
total_number = length(m);

for i = 1:1000
    if (i == 1)
        total(i) = count(1);
    else
        total(i) = total(i-1) + count(i);
    end
end

%h3=plot(sorted(pos_array), m_array, str);
h3 = plot(0:1/1000:1-1/1000, total/total_number, str);
set(h3, 'color', str);set(h3, 'LineWidth', 2);
set(h3, 'LineStyle', linestyle);
return

sorted = sort(m(:));
N = length(sorted);
m = N;
if N>precision m=precision; end
m_array = 1/m:1/m:1;
pos_array = round(m_array.*N);
h3=plot(sorted(pos_array), m_array, str);
set(h3, 'color', str);set(h3, 'LineWidth', 2);
set(h3, 'LineStyle', linestyle);
return
%plot a cumulative graph of matrix m with M*N
    [M,N] = size(m);
    a = M*N;
    m_array = 1/a:1/a:1;
    f_array = reshape(m,1,a);
    plot(sort(f_array),m_array,str)
    


