function measure_error(DATA, max_round, L, dim)

N = length(DATA); %should get 110 here

% L = 15;
% dim = 10;


average_re_ides = [];
average_re_yogurt = [];
figure(5);

for p = 0:0.01:0.1

    temp_re_ides = [];
    temp_re_yogurt = [];
    
    for round = 1:max_round
        
        DATA_TEST = DATA;
        
        for i=1:N
            for j=1:N
                a=rand;
                if (i ~=j && a<p)
                    DATA_TEST(i,j)=DATA_TEST(i,j)*5;
                end
            end
        end



        tmp = randperm(N); 
        landmarks = tmp(1:L); % choose random L nodes as landmarks
        hosts = tmp(L+1:N);  % the rest of them are orinary hosts
        
        D_landmark = DATA_TEST(landmarks, landmarks);
        D_host2landmark = DATA_TEST(hosts, landmarks);
            
        %    'START IDES (NMF)'
        [out_l, in_l, out_h, in_h] = ides_NMF(reconstruct(D_landmark), D_host2landmark, dim);
        rerr=relative_error(out_h*in_h, DATA(hosts, hosts));
        temp_re_ides = [temp_re_ides median(rerr')];
        %    'START IDES (NMF08)'
        [out_l, in_l, out_h, in_h] = ides_NMF08(reconstruct(D_landmark), D_host2landmark, dim);
        rerr=relative_error(out_h*in_h, DATA(hosts, hosts));
        temp_re_yogurt = [temp_re_yogurt median(rerr')];          
            
    end
%    [mean(temp_re_ides) mean(temp_re_yogurt)]
    average_re_ides = [average_re_ides mean(temp_re_ides)];
    average_re_yogurt = [average_re_yogurt mean(temp_re_yogurt)];
    
end

average_re_ides
average_re_yogurt

h0=plot(0:0.01:0.1, average_re_ides);set(h0, 'LineStyle', ':');set(h0, 'color', 'g');
xlabel('p: fraction of inacurate measurement', 'FontSize', 16);ylabel('average median relative errorn', 'FontSize', 16);axis([0 0.1 0 1]);hold on;set(h0, 'LineWidth', 2);
h1=plot(0:0.01:0.1, average_re_yogurt);set(h1, 'LineStyle', '-');set(h1, 'color', 'b');
xlabel('p: fraction of inaccurate measurement', 'FontSize', 16);ylabel('average median relative error', 'FontSize', 16);axis([0 0.1 0 1]);hold on;set(h1, 'LineWidth', 2);


h4=legend('IDES', 'YOGURT', 4);set(h4, 'FontSize', 16);

% xlabel: p: fraction of inacurate measurement
% ylabel: average median relative error